package clnaddr.ws;

/**
 * <p>Title: Address check  object</p>
 * <p>Description: Java JNI call the Com object of the Melissadata Com</p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Company: Resource free</p>
 * @author Tri, Tran Huu
 * @version 1.0
 */

public class AddrressClient {
  private static AddrressClient addrObj;

  public static AddrressClient getInstance() {
    if (addrObj == null) {
      addrObj = new AddrressClient();
    }
    addrObj.regsrvComNameObj();
    addrObj.comInitialize();
    return addrObj;
  }

  /**
   * Get a instance
   * @param flag boolean init com if flag is true
   * @return AddrObj
   */
  public static AddrressClient getInstance(boolean flag) {
    if (addrObj == null) {
      addrObj = new AddrressClient();
    }
    if (flag) {
      addrObj.regsrvComNameObj();
      addrObj.comInitialize();
    }
    return addrObj;
  }

  /**
   * register name obj
   * Returns a value greater than 32 if successful,
   * or an error value that is less than or equal to 32 otherwise.
   * @return int
   */
  public native long regsrvComNameObj();

  /**
   * Un register name object
   * Returns a value greater than 32 if successful,
   * or an error value that is less than or equal to 32 otherwise.
   * @return int
   */
  public native long unRegsrvComNameObj();

  /**
   * Initializes the COM library
   * @return null if init success else return the error message
   */
  public native String comInitialize();

  /**
   * Uninitializes the COM library
   */
  public native void comUninitialize();

  /**
   * Set melissadata license
   * @param license
   * @return
   */

  public native boolean setLicenseString(String license);

  public native int initializeDataFiles();

  public native String getInitializeErrorString();

  public native boolean verifyAddress();

  public native String getBuildNumber();

  public native String getUSDatabaseDate();

  public native String getUSExpirationDate();

  public native String getCanadianDatabaseDate();

  public native String getCanadianExpirationDate();

  public native void clearProperties();

  public native void disableAddressSwapping(boolean flag);

  public native String getCASSForm();

  public native boolean saveCASSForm(String path);

  public native void resetCASSForm();

  public native void setPathToCanadianFiles(String path);

  public native void setPathToUSFiles(String path);

  public native void setPathToDPVFiles(String path);

  /**
   * Parser interface
   */
  public native boolean parse(String address);

  public native boolean parseNext();

  public native String pGetBuildNumber();

  public native String lastLineParse(String str);

  /* Parsed output data (method) */
  public native String getParsedAddressRange();

  public native String getParsedPreDirection();

  public native String getParsedStreetName();

  public native String getParsedSuffix();

  public native String getParsedPostDirection();

  public native String getParsedSuiteName();

  public native String getParsedSuiteRange();

  public native String getParsedPrivateMailboxName();

  public native String getParsedPrivateMailboxNumber();

  /* Parser output data (properties) */

  public native String pGetCity();

  public native String pGetState();

  public native String pGetZip();

  public native String pGetPlus4();

  public native String pGetRange();

  public native String pGetPreDirection();

  public native String pGetStreetName();

  public native String pGetSuffix();

  public native String pGetPostDirection();

  public native String pGetSuiteName();

  public native String pGetSuiteNumber();

  public native String pGetPrivateMailBoxName();

  public native String pGetPrivateMailBoxNumber();

  public native String pGetGarbage();

  /* Address output data */

  public native String getCompany();

  public native String getAddress();

  public native String getAddress2();

  public native String getSuite();

  public native String getCity();

  public native String getCityAbbreviation();

  public native String getState();

  public native String getCountryCode();

  public native String getZip();

  public native String getZipType();

  public native String getPlus4();

  public native String getCarrierRoute();

  public native String getDeliveryPointCode();

  public native String getDeliveryPointCheckDigit();

  public native String getCountyFips();

  public native String getCountyName();

  public native String getTimeZone();

  public native String getTimeZoneCode();

  public native String getErrorCode();

  public native String getCMRA();

  public native String getDPVFootnotes();

  public native String getErrorString();

  public native String getMsa();

  public native String getPmsa();

  public native String getAddressTypeCode();

  public native String getAddressTypeString();

  public native String getUrbanization();

  public native String getCongressionalDistrict();

  public native String getLacs();

  public native String getStatusCode();

  public native String getSuiteStatusCode();

  public native String getPrivateMailBox();

  public native String getLastLine();

  /* Address input  data */

  public native void setCompany(String company);

  public native void setAddress(String address);

  public native void setAddress2(String address);

  public native void setSuite(String suite);

  public native void setCity(String city);

  public native void setState(String state);

  public native void setCountryCode(String countryCode);

  public native void setZip(String zip);

  public native void setPlus4(String plus4);

  public native void setUrbanization(String urbanization);

//Optional output
  public native void setParsedAddressRange(String parseAddressRange);

  public native void setParsedPreDirection(String parsedPreDirection);

  public native void setParsedStreetName(String parsedStreetName);

  public native void setParsedSuffix(String parsedSuffix);

  public native void setParsedPostDirection(String parsedPostDirection);

  public native void setParsedSuiteName(String parsedSuiteName);

  public native void setParsedSuiteRange(String parsedSuiteRange);

//CASS form 3553 methods
  public native void setProcessorName3553(String processorName3553);

  public native void setListName3553(String listName3553);

  public native void setName3553(String name3553);

  public native void setCompany3553(String company3553);

  public native void setAddress3553(String address3553);

  public native void setCity3553(String city3553);

  public native void setState3553(String state3553);

  public native void setZip3553(String zip3553);

  /**
   * Street Data Interface
   * Methods
   */

  public native boolean sSetLicenseString(String license);

  public native int initialize(String MP4DataPath, String NationalDataPath,
                               String RegionalDataPath);

  public native String sGetInitializeErrorString();

  public native boolean findStreet(String StreetName, String Zip,
                                   boolean ZipCodeOnly);

  public native boolean findStreetNext();

  public native String sGetBuildNumber();

  public native String sGetDatabaseDate();

  public native boolean IsAddressInRange(String range, String PrimaryRangeLow,
                                         String PrimaryRangeHigh);

  public native boolean IsAddressInRange2(String range, String PrimaryRangeLow,
                                          String PrimaryRangeHigh,
                                          String PrimaryRangeOddEven);

  // properties
  public native String sGetCompany();

  public native String sGetPrimaryRangeLow();

  public native String sGetPrimaryRangeHigh();

  public native String sGetPrimaryRangeOddEven();

  public native String sGetPreDirection();

  public native String sGetStreetName();

  public native String sGetSuffix();

  public native String sGetPostDirection();

  public native String sGetSuiteName();

  public native String sGetSuiteRangeLow();

  public native String sGetSuiteRangeHigh();

  public native String sGetSuiteRangeOddEven();

  public native String sGetZip();

  public native String sGetPlus4Low();

  public native String sGetPlus4High();

  public native String sGetCarrierRoute();

  public native String sGetCountyFips();

  public native String sGetCongressionalDistrict();

  public native String sGetAddressType();

  public native String sGetLastLineNumber();

  public native String sGetUrbanizationCode();

  public native String sGetLacsIndicator();

  public native String sGetBaseAlternateIndicator();

  /**
   * ZIPCode Data Interface
   */
  public native boolean zSetLicenseString(String License);

  public native int zInitialize(String MP4DataPath, String NationalDataPath,
                                String RegionalDataPath);

  public native String zGetInitializeErrorString();

  public native String computeBearing(String latitude1, String longitude1,
                                      String latitude2, String longitude2);

  public native String computeDistance(String latitude1, String longitude1,
                                       String latitude2, String longitude2);

  public native boolean findZip(String zip, boolean flag);

  public native boolean findZipNext();

  public native boolean findZipInCity(String City, String State);

  public native boolean findZipInCityNext();

  public native boolean findCityInState(String City, String State);

  public native boolean findCityInStateNext();

  public native String zGetBuildNumber();

  public native String zGetDatabaseDate();

  // Properties

  public native String zGetZip();

  public native String zGetZipType();

  public native String zGetState();

  public native String zGetCity();

  public native String zGetCountyFips();

  public native String zGetCountyName();

  public native String zGetLastLineIndicator();

  public native String zGetFacilityCode();

  public native String zGetMsa();

  public native String zGetPmsa();

  public native String zGetAutomation();

  public native String zGetLastLineNumber();

  public native String zGetPreferredLastLineNumber();

  public native String zGetCityAbbreviation();

  public native String zGetTimeZone();

  public native String zGetTimeZoneCode();

  public native String zGetLatitude();

  public native String zGetLongitude();

  public native String zGetAreaCode();

  static {
    System.loadLibrary("jAddrObj");
  }

}
